function ParticleSystem(){

this.produceDelay = 0;
this.produceFrame = 0;
this.produceDelayVar = 0;
this.produceCount = 1;

this.images = [];
this.randomizeImages = false;
this.imageIndex = 0;

this.startPosition = [0,0];
this.startSize = [0,0];
this.startRotation = 0;
this.startColor = [0,0,0,0];

this.startPositionVar = [0,0];
this.startSizeVar = [0,0];
this.startRotationVar = 0;
this.startColorVar = [0,0,0,0]

this.flyPosition = [0,0];
this.flySize = [0,0];
this.flyRotation = 0;
this.flyColor = [0,0,0,0];

this.flyPositionVar = [0,0];
this.flySizeVar = [0,0];
this.flyRotationVar = 0;
this.flyColorVar = [0,0,0,0];


this.maxParticles = 0;
this.particleLifetime = 1;
this.particleLifetimeVar = 0;
this.randomizeDelay = 0;
this.fadeOutAtPercent = 100;

this.gravitationCenter = [];
this.gravitationBreak = 1;

this.particles = [];


this.producing= false;
}



ParticleSystem.prototype.startProduce = function(){
	
	this.producing = true;

}


ParticleSystem.prototype.render = function(){

	with(this){
	
		if(producing && particles.length<maxParticles){
						
				
				this.produceFrame++;
				if(this.produceFrame>this.produceDelay){
					this.produceFrame = 0;
					for(var pc=0;pc<produceCount;pc++)
						particles.push(this.produceParticle());
					}
				
	
				
							
					
				}
			
		//GetSystemFont().drawText(100,100,"rendering particles: "+particles.length);	
		for(var i=0;i<particles.length;i++)
		{
			
			
			particles[i].applyGravitationCenter(gravitationCenter,gravitationBreak);
			
			particles[i].render();
			
			if(particles[i].lifetime<0){
				particles.splice(i,i+1);
				i--;
			}
		
			}
		}
	
}


ParticleSystem.prototype.renderWithMapTransformation = function(layer){

	with(this){
	
		if(producing && particles.length<maxParticles){
						
				
				this.produceFrame++;
				if(this.produceFrame>this.produceDelay){
					this.produceFrame = 0;
					for(var pc=0;pc<produceCount;pc++)
						particles.push(this.produceParticle());
					}
				
	
				
							
					
				}
			
		//GetSystemFont().drawText(100,100,"rendering particles: "+particles.length);	
		for(var i=0;i<particles.length;i++)
		{
			
			particles[i].applyGravitationCenter(gravitationCenter,gravitationBreak);
				
			particles[i].renderWithMapTransformation(layer);
			
			if(particles[i].lifetime<0){
				particles.splice(i,i+1);
				i--;
			}
		
			}
		}
	
}

ParticleSystem.prototype.stopProduce = function(){

	this.producing = false;
	
}

ParticleSystem.prototype.produceParticle = function(){

		
	var p = new Particle();

	
	p.position[0] = this.startPosition[0]+Math.random()*this.startPositionVar[0];
	p.position[1] = this.startPosition[1]+Math.random()*this.startPositionVar[1];
	
	p.size[0] = this.startSize[0]+Math.random()*this.startSizeVar[0];
	p.size[1] = this.startSize[1]+Math.random()*this.startSizeVar[1];
	
	p.rotation = this.startRotation+Math.random()*this.startRotationVar;
	p.color = CreateColor(this.startColor[0]+Math.random()*this.startColorVar[0],
												this.startColor[1]+Math.random()*this.startColorVar[1],
												this.startColor[2]+Math.random()*this.startColorVar[2],
												this.startColor[3]+Math.random()*this.startColorVar[3])

	p.flyPosition[0] = this.flyPosition[0]+Math.random()*this.flyPositionVar[0];
	p.flyPosition[1] = this.flyPosition[1]+Math.random()*this.flyPositionVar[1];
	p.flySize[0] = this.flySize[0]+Math.random()*this.flySizeVar[0];
	p.flySize[1] = this.flySize[1]+Math.random()*this.flySizeVar[1];
	p.flyRotation = this.flyRotation+Math.random()*this.flyRotationVar;
	
	p.flyColor[0] = this.flyColor[0]+Math.random()*this.flyColorVar[0];
	p.flyColor[1] = this.flyColor[1]+Math.random()*this.flyColorVar[1];
	p.flyColor[2] = this.flyColor[2]+Math.random()*this.flyColorVar[2];
	p.flyColor[3] = this.flyColor[3]+Math.random()*this.flyColorVar[3];

	if(this.images.length>0){
		if(this.randomizeImages){
		  p.image = this.images[Math.min(Math.floor(Math.random()*this.images.length),this.images.length-1)];
		  }
		else {
			p.image = this.images[this.imageIndex];
			}
		}
		
	
	p.lifetime =this.particleLifetime+Math.random()*this.particleLifetimeVar;
	
	p.fadeOutPoint = p.lifetime/100*this.fadeOutAtPercent;
	
	return p;
	
}













/////////////////////////
function Particle(){

this.position = [0,0];
this.size = [0,0];
this.rotation = 0;
this.color = CreateColor(0,0,0,0)

this.flyPosition = [0,0];
this.flyPositionG = [0,0];
this.flyPositionFinal = [0,0];
this.flySize = [0,0];
this.flyRotation = 0;
this.flyColor = [0,0,0,0];

this.image = undefined;
this.lifetime = 0;
this.fadeOutPoint = 0;

}

Particle.prototype.applyGravitationCenter = function(tmpgclist,tmpbreak){
	
	var tmpd=0;
	with(this){
			
		
		for(var i=0;i<tmpgclist.length;i++){
			tmpd = Math.sqrt(((tmpgclist[i][0]-position[0])*(tmpgclist[i][0]-position[0])+(tmpgclist[i][1]-position[1])*(tmpgclist[i][1]-position[1])))
			
			
			if(tmpd<1)tmpd=1;
			
			flyPositionG[0] += (tmpgclist[i][0]-position[0])/tmpd*tmpgclist[i][3]*(Math.max(0,tmpgclist[i][2]-tmpd))/tmpgclist[i][2];
			flyPositionG[1] += (tmpgclist[i][1]-position[1])/tmpd*tmpgclist[i][3]*(Math.max(0,tmpgclist[i][2]-tmpd))/tmpgclist[i][2];
									
				
		}
		flyPositionG[0] /= tmpbreak;
		flyPositionG[1] /= tmpbreak;
		flyPositionFinal[0] = flyPositionG[0]+flyPosition[0];
		flyPositionFinal[1] = flyPositionG[1]+flyPosition[1];
	}
	
	
}

Particle.prototype.render = function(){

	with(this){
		
		position[0] += flyPositionFinal[0];
		position[1] += flyPositionFinal[1];
				
		size[0] =  size[0] + flySize[0];
		size[1] = size[1] + flySize[1];
		
		
		rotation += flyRotation;
		
		color.red = Math.min(Math.max(color.red+flyColor[0],0),255)
		color.green = Math.min(Math.max(color.green+flyColor[1],0),255)
		color.blue = Math.min(Math.max(color.blue+flyColor[2],0),255)
		color.alpha = Math.min(Math.max(color.alpha+flyColor[3],0),255)*(1-(Math.max(0,this.fadeOutPoint-this.lifetime)/this.fadeOutPoint))
		
		lifetime--;
		
		var r = Math.sqrt(size[0]/2*size[0]/2+size[1]/2*size[1]/2);
		
		if(size[0]==0||size[1]==0||position[0]<-r||position[0]>GetScreenWidth()+r||position[1]<-r||position[1]>GetScreenHeight()+r||color.alpha==0)
			return;
		
		var beta = Math.acos(size[0]/2/r);
		//Circle(position[0],position[1],r,color);
		
		/*var px = [
						position[0]+size[0]/2*Math.cos((Math.PI-beta)+(rotation*Math.PI/180)),
						position[0]+size[0]/2*Math.cos((beta)+(rotation*Math.PI/180)),
						position[0]+size[0]/2*Math.cos((Math.PI*2-beta)+(rotation*Math.PI/180)),
						position[0]+size[0]/2*Math.cos((Math.PI+beta)+(rotation*Math.PI/180))
						
						];
		var py = [
						position[1]+size[1]/2*Math.sin((Math.PI-beta)+(rotation*Math.PI/180)),
						position[1]+size[1]/2*Math.sin((beta)+(rotation*Math.PI/180)),
						position[1]+size[1]/2*Math.sin((Math.PI*2-beta)+(rotation*Math.PI/180)),
						position[1]+size[1]/2*Math.sin((Math.PI+beta)+(rotation*Math.PI/180))
						
						
						];*/
		var px = [
						position[0]+r*Math.cos((Math.PI-beta)+(rotation*Math.PI/180)),
						position[0]+r*Math.cos((beta)+(rotation*Math.PI/180)),
						position[0]+r*Math.cos((Math.PI*2-beta)+(rotation*Math.PI/180)),
						position[0]+r*Math.cos((Math.PI+beta)+(rotation*Math.PI/180))
						
						];
		var py = [
						position[1]+r*Math.sin((Math.PI-beta)+(rotation*Math.PI/180)),
						position[1]+r*Math.sin((beta)+(rotation*Math.PI/180)),
						position[1]+r*Math.sin((Math.PI*2-beta)+(rotation*Math.PI/180)),
						position[1]+r*Math.sin((Math.PI+beta)+(rotation*Math.PI/180))
						
						
						];
		//GetSystemFont().drawText(px[0],py[0],"px[1]:"+px[1]);	
		if(image!=undefined){
				
				image.transformBlitMask(px[0],py[0],px[1],py[1],px[2],py[2],px[3],py[3],color);
				//GetSystemFont().drawText(px[0],py[0],"px[1]:"+px[1]);	
				//Triangle(px[0], py[0], px[1], py[1], px[2], py[2], color)
				//Rectangle(px[0],py[0],size[0],size[1],color);
				/*Polygon(
					[
						new function(){this.x=px[0];this.y=py[0];},
						new function(){this.x=px[1];this.y=py[1];},
						new function(){this.x=px[2];this.y=py[2];},
						new function(){this.x=px[3];this.y=py[3];},
						], color );*/
			}
		else{
			
			Rectangle(px[0],py[0],size[0],size[1],color);
			
			}
		
	}

}

Particle.prototype.renderWithMapTransformation = function(layer){

	if(!IsMapEngineRunning())return;
	with(this){
		
		position[0] += flyPositionFinal[0];
		position[1] += flyPositionFinal[1];
		
		
		
		size[0] =  size[0] + flySize[0];
		size[1] = size[1] + flySize[1];
		
		
		rotation += flyRotation;
		
		color.red = Math.min(Math.max(color.red+flyColor[0],0),255)
		color.green = Math.min(Math.max(color.green+flyColor[1],0),255)
		color.blue = Math.min(Math.max(color.blue+flyColor[2],0),255)
		color.alpha = Math.min(Math.max(color.alpha+flyColor[3],0),255)*(1-(Math.max(0,this.fadeOutPoint-this.lifetime)/this.fadeOutPoint))
		
		lifetime--;
		
		var r = Math.sqrt(size[0]/2*size[0]/2+size[1]/2*size[1]/2);
		
		if(size[0]==0||size[1]==0||MapToScreenX(layer,position[0])<-r||MapToScreenX(layer,position[0])>GetScreenWidth()+r||MapToScreenY(layer,position[1])<-r||MapToScreenY(layer,position[1])>GetScreenHeight()+r||color.alpha==0)
			return;
		
		var beta = Math.acos(size[0]/2/r);
		//Circle(position[0],position[1],r,color);
		
		/*var px = [
						position[0]+size[0]/2*Math.cos((Math.PI-beta)+(rotation*Math.PI/180)),
						position[0]+size[0]/2*Math.cos((beta)+(rotation*Math.PI/180)),
						position[0]+size[0]/2*Math.cos((Math.PI*2-beta)+(rotation*Math.PI/180)),
						position[0]+size[0]/2*Math.cos((Math.PI+beta)+(rotation*Math.PI/180))
						
						];
		var py = [
						position[1]+size[1]/2*Math.sin((Math.PI-beta)+(rotation*Math.PI/180)),
						position[1]+size[1]/2*Math.sin((beta)+(rotation*Math.PI/180)),
						position[1]+size[1]/2*Math.sin((Math.PI*2-beta)+(rotation*Math.PI/180)),
						position[1]+size[1]/2*Math.sin((Math.PI+beta)+(rotation*Math.PI/180))
						
						
						];*/
		var px = [
						position[0]+r*Math.cos((Math.PI-beta)+(rotation*Math.PI/180)),
						position[0]+r*Math.cos((beta)+(rotation*Math.PI/180)),
						position[0]+r*Math.cos((Math.PI*2-beta)+(rotation*Math.PI/180)),
						position[0]+r*Math.cos((Math.PI+beta)+(rotation*Math.PI/180))
						
						];
		var py = [
						position[1]+r*Math.sin((Math.PI-beta)+(rotation*Math.PI/180)),
						position[1]+r*Math.sin((beta)+(rotation*Math.PI/180)),
						position[1]+r*Math.sin((Math.PI*2-beta)+(rotation*Math.PI/180)),
						position[1]+r*Math.sin((Math.PI+beta)+(rotation*Math.PI/180))
						
						
						];
		//GetSystemFont().drawText(px[0],py[0],"px[1]:"+px[1]);	
		if(image!=undefined){
				
				image.transformBlitMask(
					MapToScreenX(layer,px[0]),
					MapToScreenY(layer,py[0]),
					MapToScreenX(layer,px[1]),
					MapToScreenY(layer,py[1]),
					MapToScreenX(layer,px[2]),
					MapToScreenY(layer,py[2]),
					MapToScreenX(layer,px[3]),
					MapToScreenY(layer,py[3]),
					color);
				
			}
		else{
			
			Rectangle(px[0],py[0],size[0],size[1],color);
			
			}
		
	}

}



////////////////PRESETS


function PS_Preset_Fire(){


	var ps = new ParticleSystem();
	
	ps.produceDelay = 2;
	ps.produceDelayVar = 0;
	
	ps.images = [objectsystem.image.get("effekt/e_kugel.png")];
	ps.randomizeImages = false;
	ps.imageIndex = 0;
	
	ps.startPosition = [100,100];
	ps.startSize = [10,10];
	ps.startRotation = 0;
	ps.startColor = [255,200,0,0];
	
	ps.startPositionVar = [2,2];
	ps.startSizeVar = [2,2];
	ps.startRotationVar = 0;
	ps.startColorVar = [0,0,0,0]
	
	ps.flyPosition = [0.1,-1];
	ps.flySize = [0,0];
	ps.flyRotation = 0;
	ps.flyColor = [-10,-20,0,20];
	
	ps.flyPositionVar = [-0.2,1];
	ps.flySizeVar = [0,0];
	ps.flyRotationVar = 0;
	ps.flyColorVar = [2,5,0,10];
	
	ps.maxParticles = 20;
	ps.randomizeDelay = 0;
	ps.particleLifetime = 20;
	ps.fadeOutAtPercent = 30;
	
	//ps.startProduce();

	return ps;

}


function PS_Preset_Kaminfeuer(){


	var ps = new ParticleSystem();
	
	ps.produceDelay = 10;
	ps.produceDelayVar = 0;
	
	ps.images = [objectsystem.image.get("effekt/e_kugel.png")];
	ps.randomizeImages = false;
	ps.imageIndex = 0;
	
	ps.startPosition = [100,100];
	ps.startSize = [20,5];
	ps.startRotation = 0;
	ps.startColor = [255,200,0,0];
	
	ps.startPositionVar = [5,0];
	ps.startSizeVar = [2,2];
	ps.startRotationVar = 0;
	ps.startColorVar = [10,10,0,0]
	
	ps.flyPosition = [0,-0.3];
	ps.flySize = [-0.1,0.5];
	ps.flyRotation = -0.5;
	ps.flyColor = [-5,-10,0,2];
	
	ps.flyPositionVar = [0,0];
	ps.flySizeVar = [0,0];
	ps.flyRotationVar = 1;
	ps.flyColorVar = [2,5,0,10];
	
	ps.maxParticles = 50;
	ps.randomizeDelay = 0;
	ps.particleLifetime = 100;
	ps.fadeOutAtPercent = 80;
	
	//ps.startProduce();

	return ps;

}


function PS_Preset_LearnElement(r,g,b){


	var ps = new ParticleSystem();
	
	ps.produceDelay = 10;
	ps.produceDelayVar = 0;
	
	ps.images = [objectsystem.image.get("effekt/e_licht.png")];
	ps.randomizeImages = false;
	ps.imageIndex = 0;
	
	ps.startPosition = [GetScreenWidth()/2,GetScreenHeight()/2];
	ps.startSize = [50,50];
	ps.startRotation = 0;
	ps.startColor = [r,g,b,0];
	
	ps.startPositionVar = [0,0];
	ps.startSizeVar = [10,10];
	ps.startRotationVar = 360;
	ps.startColorVar = [0,0,0,0]
	
	ps.flyPosition = [0,0];
	ps.flySize = [-0.2,-0.2];
	ps.flyRotation = 2;
	ps.flyColor = [1,1,1,20];
	
	ps.flyPositionVar = [0,0];
	ps.flySizeVar = [0,0];
	ps.flyRotationVar = -4;
	ps.flyColorVar = [0,0,0,10];
	
	ps.maxParticles = 50;
	ps.randomizeDelay = 0;
	ps.particleLifetime = 50;
	ps.fadeOutAtPercent = 30;
	
	//ps.startProduce();

	return ps;

}
